const pluginsList = document.getElementById("plugins");

async function getPlugins() {
    const response = await fetch("/plugins");
    if (!response.ok) {
        console.error(`Response status: ${response.status}`);
    }

    return (await response.json()).plugins;
}

async function refreshPlugins() {
    const plugins = await getPlugins();

    pluginsList.innerHTML = "";
    plugins.forEach(plugin => {
        const inner = document.createElement("div");
        inner.className = "plugin";
        inner.dataset.path = plugin.path;
        inner.dataset.running = plugin.running;
        inner.dataset.watching = plugin.watching;
        inner.innerHTML = `<div class="plugin-info">
    <div class="plugin-name">${plugin.name}</div>
    <div class="plugin-path">${plugin.path}</div>
</div>
<div class="plugin-buttons">
    <button class="plugin-reload">Reload</button>
    <button class="plugin-watch">Watch</button>
    <button class="plugin-unload">Unload</button>
</div>`;
        pluginsList.appendChild(inner);
    })
}

refreshPlugins();

async function sendPluginAction(plugin, action) {
    const path = plugin.dataset.path;
    await fetch(`/${action}?plugin=${path}`);
    await new Promise(r => setTimeout(r, 100));
    await refreshPlugins();
}

pluginsList.addEventListener('click', async function (e) {
    if (e.target.className === 'plugin-reload') {
        await sendPluginAction(e.target.closest('.plugin'), "reload");
    } else if (e.target.className === 'plugin-watch') {
        await sendPluginAction(e.target.closest('.plugin'), "watch");
    } else if (e.target.className === 'plugin-unload') {
        await sendPluginAction(e.target.closest('.plugin'), "unload");
    }
}, false);